USE OLAP
--Insert sales into appropriate table
INSERT INTO sales_2016
SELECT * FROM ##sales
WHERE datepart(year,[Date])=2016

--check all sales are in 2016
SELECT min([Date]) as earliest, max([Date]) as latest
FROM sales_2016

INSERT INTO sales_2017
SELECT * FROM ##sales
WHERE datepart(year,date)=2017

--check all sales are in 2017
SELECT min([Date]) as earliest,max([Date]) as latest
FROM sales_2017

--Insert to split columns
INSERT INTO products(Code, Product_line
						,Product_type
						,Product
						,Product_cost)
	SELECT Code, Product_line
			,OLTP.dbo.proper_case(OLTP.dbo.findstringto([Product_type/Product],'/')) --Product_type
			,OLTP.dbo.proper_case(OLTP.dbo.findstringfrom([Product_type/Product],'/')) -- Product
			,Product_cost
		FROM ##products

--check products table has been populated
SELECT * FROM products

--Eliminating Duplicates - Check if we have duplicates
SELECT country,city,count(*)  as count
FROM ##countries 
GROUP BY country,city
HAVING count(*) > 1

--If we do then we will need distinct:
INSERT INTO countries
	SELECT distinct country,city
	FROM ##countries

--Otherwise just do a straight insert:
INSERT INTO countries
	SELECT country,city
	FROM ##countries

--check we don't have any duplicates in our final table
SELECT country,city,count(*) as count
FROM countries 
GROUP BY country,city
HAVING count(*) > 1 